
-- This structure wraps operations specific to Max Creation Graph
global lvops --using lvops "ListViewOps" struct definition found in <3dsmax>\stdplugs\stdscripts\NET_ListViewWrapper.ms
struct MCGParameterOps
(
	--Resources
	AddButtonText = ~ARRAYPARAM_ADD~,
	UpdateButtonText = ~ARRAYPARAM_UPDATE~,
	InsertButtonText = ~ARRAYPARAM_INSERT~,
	RemoveButtonText = ~ARRAYPARAM_REMOVE~,
	ArrayParamValueText = ~ARRAYPARAM_VALUE~,
	ReinitSimButtonText = ~REINITSIM_VALUE~,
	NoAssetToolTipTest = ~ASSETPARAM_NOFILE_TEXT~,
	
	NodeWrapperClass = dotNetClass "Autodesk.Max.MaxPlus.INode",
	fn InitListView table columnNamesArray colWidths =
	(
		local colNames = #("") + columnNamesArray
		lvops.InitListView table pLabelEdit:false pAllowReorder:false pInitColumns:colNames pInitColWidths:colWidths pCheckBoxes:false
		local sortOrder = dotNetClass "System.Windows.Forms.SortOrder"
		table.Sorting = sortOrder.None; --remove the sorting
		table.hideSelection = false --show row selection
	),
	fn GetSelectionIndices lv = --returns an array of indices hat are zero based.
	(
		local count = lv.SelectedItems.Count-1
		local indices = #()
		for i = count to 0 by -1 do
		(
			append indices (lv.SelectedItems.Item[i].index)
		)
		return indices
	),
	fn FillInOneColTable lv objectsList objectToStringFunc =
	(
		local theRange = #()
		local LineNumber = 1
		for o in objectsList do
		(
			li = dotNetObject "System.Windows.Forms.ListViewItem" (lineNumber as string)
			li.SubItems.add (objectToStringFunc o)
			append theRange li
			LineNumber=LineNumber+1
		)
		lv.Items.Clear()
		lv.Items.AddRange theRange
	),
	fn MakeNodeWrapper obj =
	(
		if(NodeWrapperClass == undefined) do
		(
			NodeWrapperClass = dotNetClass "Autodesk.Max.MaxPlus.INode"
		)
		return (NodeWrapperClass._CreateWrapper obj)
	),
	fn ToStringFunc n =  ( n as string ),
	fn INodeToStringFunc n = 
	( 
		if(n == undefined) then
		(
			return "undefined"
		)
		else
		(
			return n.name 
		)
	),
	fn OneColParamsOpen ui tab toStringMethod colNamesArray &selected: = 
	(
		InitListView ui colNamesArray #(20,99)
		FillInOneColTable ui tab toStringMethod
		--load list selection
		for item in selected do
		(
			lvops.SelectLvItem ui item
		)
		selected = #()
	),
	fn OneColParamsClose ui &selected: =
	(
		--save list selection
		local count = ui.SelectedItems.Count-1
		while (ui.items.count > 0 and count >= 0) do
		(
			append selected (ui.SelectedItems.Item[count].index)
			count = count - 1
		)
	),
	fn OneColArrayParamPreInvoke ui tab paramsOpen toStringMethod = 
	(
		if paramsOpen do
		(
			for n =1 to (tab.count) do
			(
				local val = lvops.GetLvItemName ui (n-1) 1
				local tabVal = toStringMethod(tab[n])
				if(val != tabVal) do
				(
					lvops.SetLvItemName ui (n-1) 1 tabVal
				)
			)
		)
	),
	
	
	--Float Parameter Array Functions
	fn FloatA_Initialization &list: = 
	(
		if list == undefined then
		(
			list = (dotNetClass "Viper3dsMaxBridge.FloatList").CreateInstance()
		)
		else
		(
			list.Clear()
		)
	),
	fn FloatA_ParamPreInvoke ui list tab paramsOpen = 
	(
		--update UI
		OneColArrayParamPreInvoke ui tab paramsOpen ToStringFunc
		--Always Update List
		list.Clear()
		for ele in tab do
		(
			list.AddElement ele
		)
	),
	fn FloatA_TabChanged action index count ui list tab =
	(
		if action == #append then
		(
			for i = 1 to count do
			(
				lvops.AddLvItem ui pTextItems:#(index as string, tab[index] as string)
			)
		)
		if action == #insert then
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
			lvops.SelectLvItem ui (index-1)
		)
		else if action == #SetCount then
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
		)
		else if action == #delete then
		(
			for i = 0 to count-1 do
			(
				lvops.DeleteLvItem ui (index+i-1)
			)
			--update the line numbers
			for i = index-1 to ui.items.count-1 do
			(
				lvops.SetLvItemName ui i 0 ((i+1) as string)
			)
		)
		else if action == #sort then
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
		)
		else
		(
			ui.items.Clear()
			FillInOneColTable ui tab ToStringFunc
		)
	),
	fn FloatA_TabSet val index ui list = 
	(
		lvops.SetLvItemName ui (index-1) 1 val
	),
	fn FloatA_AddToList tab spinner =
	(
		append tab spinner.value
	),
	fn FloatA_UpdateSelected ui tab spinner =
	(
		local indecies = GetSelectionIndices ui
		for index in indecies do
		(
			tab[index+1] = (spinner.value)
		)
	),
	fn FloatA_InsertToList ui tab spinner =
	(
		if ui.SelectedItems.Count > 0 then
		(
			index = ui.SelectedItems.Item[0].index
			insertItem (spinner.value) tab (index+1)
		)
	),
	fn FloatA_RemoveFromList ui tab =
	(
		local indecies = GetSelectionIndices ui
		for index in indecies do
		(
			deleteItem tab (index+1)
		)
	),
	
	
	--INode Parameter Array Functions
	fn INodeA_Initialization &list: = 
	(
		if list == undefined then
		(
			list = (dotNetClass "Viper3dsMaxBridge.INodeList").CreateInstance()
		)
		else
		(
			list.Clear()
		)
	),
	fn INodeA_PreInvoke ui list tab paramsOpen = 
	(
		--update UI
		OneColArrayParamPreInvoke ui tab paramsOpen INodeToStringFunc
		--Update List
		if list.list.count == 0 then
		(
			for ele in tab do
			(
				list.AddElement (MakeNodeWrapper ele)
			)
		)
	),
	fn INodeA_TabChanged action index count ui list tab paramsOpen =
	(
		list.clear() --table changed clear the list and rebuild before evaluation
		if (paramsOpen == false) then
		(
			return ok
		)
		if action == #append then
		(
			for i = 1 to count do
			(
				lvops.AddLvItem ui pTextItems:#(index as string, tab[index].name)
			)
		)
		else if action == #insert then
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
			lvops.SelectLvItem ui (index-1)
		)
		else if action == #SetCount then
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
		)
		else if action == #delete or action == #refDeleted then
		(
			for i = 0 to count-1 do
			(
				lvops.DeleteLvItem ui (index+i-1)
			)
			--update the line numbers
			for i = index-1 to ui.items.count-1 do
			(
				lvops.SetLvItemName ui i 0 ((i+1) as string)
			)
		)
		else if action == #sort then
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
		)
		else
		(
			ui.items.Clear()
			FillInOneColTable ui tab INodeToStringFunc
		)
	),
	fn INodeA_TabSet newNode index ui list paramsOpen = 
	(
		list.clear()
		if (paramsOpen == false) then
		(
			return ok
		)
		lvops.SetLvItemName ui (index-1) 1 (newNode.name)
		
	),
	fn INodePickingMethod tab =
	(
		try
		(
			local n = pickobject message:~PICKOBJECT_MESSAGE~
			while(n != undefined and n != #escape) do
			(
				if ((findItem tab n) == 0) do
				(
					append tab n --might throw exception is a dependency loop is detected
				)
				n = pickobject message:~PICKOBJECT_MESSAGE~
			)
		)
		catch ()
	),
	fn INodeA_AddToList tab state checkBtn = 
	(
		if state == on then
		(
			INodePickingMethod tab
			checkBtn.state = off
		)
		else
		(
			-- exit pickobject mode if turning the button off
			toolmode.commandmode = #SELECT
		)
	),
	fn INodeA_RemoveFromList ui tab =
	(
		local indecies = GetSelectionIndices ui
		for index in indecies do
		(
			deleteItem tab (index+1)
		)
	),
	
	--String Parameter Functions
	fn StringParameterEdit editText paramString =
	(
		if editText.text != paramString then
		(
			if editText.caption[1] != "*" then editText.caption = "*" + editText.caption
		)
		else
		(
			editText.text = paramString
			if editText.caption[1] == "*" then editText.caption = 
			editText.caption = substring editText.caption 2 (editText.caption.count-1)
		)
	),
	
	--Asset Parameter Functions
	fn AssetParamPickFile paramAsset assetUI =
	(
		local pathSeed = paramAsset
		if (pathSeed == undefined or pathSeed == "") then (
			pathSeed = (dotNetClass "Viper3dsMaxBridge.Main").UserToolsDirectory
		)
		local f = getOpenFileName caption:"" filename:pathSeed
		if f == undefined or f == "" then (
			f = undefined
		)
		else (
			assetUI.tooltip = f
		)
		return f
	),
	fn AssetParamSetToolTip paramsOpen paramAsset assetUI =
	(
		if paramsOpen then
		(
			if (paramAsset == undefined or paramAsset == "") then
			(
				assetUI.tooltip = NoAssetToolTipTest
			)
			else
			(
				assetUI.tooltip = paramAsset
			)
		)
	)
)
global mcgOps = MCGParameterOps()
global mcgAPOps = mcgOps -- for compatibility with existing custom UI code

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA80kR9Z0ddcvauyVHwLkYz3+kYQBNPA2f3
-- 7tQRWXMJUClYSyyf8vB27RhC6zk65IXbceT4VHBPNGwCnmTqqX9HqS9BbJxKJNCn
-- YqZsTTlCq/nJySdD9U9+BxSlpN6wppJK1AoWxy1k/L/3FKiOUsFCcx7upmoXZrKP
-- 4EIPQ98U5CeTrW8WZ4eaVZItamzJinbmOUkm6G1prh0EdqHhQNjpfwbvegfrXwJf
-- Z6CT8nuTPgixAWwDM3f0+3LWCV6T9mlCl/gtCXIDKRTj43YeS9+GqRugw/zVw5JB
-- CpsEXXNyXKE3bmNRiqL7xVNIDEuNNdr8IepdqV94PmmBl1v43x3x
-- -----END-SIGNATURE-----